/*
* L'URL du fichier WSDL de description du
* service de rservation.
*/
var RESERVATION_WSDL_URL = "http://www.sw-voyages.com/reservation_sw-voyages/services/ReservationService.wsdl";

/*
* L'identifiant de rservation.
*/
var reservationId;

/*
* Renvoie l'identifiant de rservation.
*/
function getReservationId() {
	return reservationId;
}

/*
* Affecte l'identifiant de rservation.
*/
function setReservationId(id) {
	reservationId = id;
}

/*
* Renvoie le modle de la table des disponibilits
* ariennes.
*/
var at;
function getAirTemplates() {
	if (at==null) {
		at = new Array(
			new Array(30,  "Choix", "id"),
			new Array(64,  "Date", null),
			new Array(100, "Compagnie", "airCompany"),
			new Array(54,  "N de vol", "flightNumber"),
			new Array(103, "Ville Dpart", "departureAirport"),
			new Array(50,  "H.Dpart", "departureHour"),
			new Array(50,  "H.Arrive", "arrivalHour"),
			new Array(102, "Ville Arrive", "arrivalAirport"),
			new Array(50,  "Prix", "price")
		);
	}
	return at;
}

/*
* Renvoie le modle de la table des disponibilits
* automobiles.
*/
var ct;
function getCarTemplates() {
	if (ct==null) {
		ct = new Array(
			new Array(30,  "Choix", "id"),
			new Array(120, "Socit de location", "carRentalCompany"),
			new Array(54,  "Catgorie", "carCategory"),
			new Array(118, "Modle", "carModel"),
			new Array(50,  "J.Arrive", null),
			new Array(50,  "J.Dpart", null),
			new Array(50,  "Prix/semaine", "pricePerWeek"),
			new Array(50,  "Prix/jour", "pricePerDay")
		);
	}
	return ct;
}

/*
* Renvoie le modle de la table des disponibilits
* htelires.
*/
var ht;
function getHotelTemplates() {
	if (ht==null) {
		ht =  new Array(
			new Array(30,  "Choix", "id"),
			new Array(120, "Chaine htelire", "hotelRentalCompany"),
			new Array(54,  "Htel", "hotelName"),
			new Array(118, "Adresse", "hotelLocation"),
			new Array(50,  "J.Arrive", null),
			new Array(50,  "J.Dpart", null),
			new Array(50,  "Prix minimum", "lowerPrice"),
			new Array(50,  "Prix maximum", "higherPrice")
		);
	}
	return ht;
}

/*
* Gre l'vnement de chargement de
* la fentre de rservation.
*/
function reservation_window_onload() {
	var today = new Date();
	var day = today.getDate();
	var month = today.getMonth();
	var year = today.getYear();
  
	search.disabled = true;

	// Alimente la list-box du jour de la date de dpart
	var i = 1;
	departure_day.options.remove(0);
	while (i < maximumDays(year, month)+1) {
  		var option = document.createElement("option");
		option.text=new Number(i).toString();
		option.value=i;
		departure_day.add(option, i);
		i++;
	}
	departure_day.selectedIndex=day-1;
	try {
		eval("departure_day_onchange()");
	}
	catch (e) {
	}

	// Alimente la list-box du jour de la date de retour
	var i = 1;
	arrival_day.options.remove(0);
	while (i < maximumDays(year, month)+1) {
  		var option = document.createElement("option");
		option.text=new Number(i).toString();
		option.value=i;
		arrival_day.add(option, i);
		i++;
	}
	arrival_day.selectedIndex=day-1;
	try {
		eval("arrival_day_onchange()");
	}
	catch (e) {
	}

	// Alimente la list-box du mois de la date de dpart
	var i = 1;
	departure_month.options.remove(0);
	while (i < 12+1) {
  		var option = document.createElement("option");
		option.text=monthAsString(i-1);
		option.value=i;
		departure_month.add(option, i);
		i++;
	}
	departure_month.selectedIndex=month;
	try {
		eval("departure_month_onchange()");
	}
	catch (e) {
	}

	// Alimente la list-box du mois de la date de retour
	var i = 1;
	arrival_month.options.remove(0);
	while (i < 12+1) {
  		var option = document.createElement("option");
		option.text=monthAsString(i-1);
		option.value=i;
		arrival_month.add(option, i);
		i++;
	}
	arrival_month.selectedIndex=month;
	try {
		eval("arrival_month_onchange()");
	}
	catch (e) {
	}

	// Alimente la list-box de l'anne de la date de dpart
	var i = year;
	departure_year.options.remove(0);
	while (i < year+2) {
  		var option = document.createElement("option");
		option.text=i;
		option.value=i;
		departure_year.add(option, i);
		i++;
	}
	departure_year.selectedIndex=0;
	try {
		eval("departure_year_onchange()");
	}
	catch (e) {
	}

	// Alimente la list-box de l'anne de la date de retour
	var i = year;
	arrival_year.options.remove(0);
	while (i < year+2) {
  		var option = document.createElement("option");
		option.text=i;
		option.value=i;
		arrival_year.add(option, i);
		i++;
	}
	arrival_year.selectedIndex=0;
	try {
		eval("arrival_year_onchange()");
	}
	catch (e) {
	}

	// Informe le comportement WebService Microsoft 
	// de la localisation du fichier de description de 
	// service  utiliser (WSDL)
	service.useService(RESERVATION_WSDL_URL,"ReservationService");
	service.showProgress=true;

	window.status = "Recherche de disponibilits accessible";
}

/*
* Gre l'vnement de chargement de
* la fentre des disponibilits.
*/
function availabilities_window_onload() {

	var information = "<p>Slectionnez vos critres de rservation SVP</p>";
	departureFlights.innerHTML = information;
	arrivalFlights.innerHTML = information;
	hotels.innerHTML = information;
	cars.innerHTML = information;

	cancel.disabled = true;
	book.disabled = true;

	window.status = "Recherche de disponibilits accessible";
}

/*
* Demande au serveur d'effectuer une nouvelle recherche
* de disponibilits. 
*/
function search_onclick() {
	window.status = "Recherche de disponibilits ...";

	var information = "<p>Slectionnez vos critres de rservation SVP</p>";
	parent.availabilities.departureFlights.innerHTML = information;
	parent.availabilities.arrivalFlights.innerHTML = information;
	parent.availabilities.hotels.innerHTML = information;
	parent.availabilities.cars.innerHTML = information;

	try {
		service.ReservationService.callService(search_callback,"search",passengers.value, from.value, 
			to.value, roundtrip.value, departure_day.value, departure_month.value, departure_year.value, arrival_day.value,
			arrival_month.value, arrival_year.value, document.all.hotel.checked, document.all.car.checked);
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
}

/*
* Gre la rponse du serveur  une nouvelle demande
* de recherche de disponibilits.
*
* @param		result le rsultat de l'appel SOAP
*/
function search_callback(result) {  
	if (soap_error(result)==true) {
		window.status = "Pas de disponibilits obtenues";
		return;
	}
	window.status = "Disponibilits obtenues";
	setReservationId(result.value);

	try {
		var service = parent.reservation.service.ReservationService;
		var reservationId = parent.reservation.getReservationId();
		service.callService(get_airAvailabilities_callback,"getAirAvailabilities",reservationId);
		if (document.all.hotel.checked) {
			service.callService(get_hotelAvailabilities_callback,"getHotelAvailabilities",reservationId);
		}
		if (document.all.car.checked) {
			service.callService(get_carAvailabilities_callback,"getCarAvailabilities",reservationId);
		}
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
}

/*
* Gre la rponse du serveur  une nouvelle demande
* de rcupration des disponibilits ariennes.
*
* @param		result le rsultat de l'appel SOAP
*/
function get_airAvailabilities_callback(result) {  
	if (soap_error(result)==true) {
		window.status = "Pas de disponibilits ariennes obtenues";
		return;
	}

	var availabilities = new Array();
	var nodes = result.raw.parentNode.selectNodes("//Item/@href");
	for (i = 0; i < nodes.length; i++) {
		var availability = result.raw.parentNode.selectSingleNode("//*[@id='"+nodes[i].nodeValue.split("#")[1]+"']");
		availabilities[i] = availability;
	}

	var information = "<p>Pas de disponibilits trouves selon vos critres de rservation</p>";
	if (roundtrip.value==0) {
		if (availabilities.length!=0) {
			getAirTemplates()[1][2] = departure_day.value + " " + monthAsString(departure_month.value-1);
			var information = build_availabilities(availabilities, getAirTemplates(), "departure_choice");
		}
		parent.availabilities.departureFlights.innerHTML = information;
	}
	else {
		var departure_availabilities = new Array();
		var arrival_availabilities = new Array();
		id = ia = 0;
		for (i = 0; i < availabilities.length; i++) {
			if (availabilities[i].getElementsByTagName("direction")[0].firstChild.nodeValue=="true") {
				departure_availabilities[id] = availabilities[i];
				id++;
			}
			else {
				arrival_availabilities[ia] = availabilities[i];
				ia++;
			}
		}
		if (departure_availabilities.length!=0) {
			getAirTemplates()[1][2] = departure_day.value + " " + monthAsString(departure_month.value-1);
			var information = build_availabilities(departure_availabilities, getAirTemplates(), "departure_choice");
		}
		parent.availabilities.departureFlights.innerHTML = information;
		information = "<p>Pas de disponibilits trouves selon vos critres de rservation</p>";
		if (departure_availabilities.length!=0) {
			getAirTemplates()[1][2] = arrival_day.value + " " + monthAsString(arrival_month.value-1);
			information = build_availabilities(arrival_availabilities, getAirTemplates(), "arrival_choice");
		}
		parent.availabilities.arrivalFlights.innerHTML = information;
	}
	switch_frame(parent.availabilities);
	
	window.status = "Disponibilits ariennes obtenues";
}

/*
* Gre la rponse du serveur  une nouvelle demande
* de rcupration des disponibilits htelires.
*
* @param		result le rsultat de l'appel SOAP
*/
function get_hotelAvailabilities_callback(result) {  
	if (soap_error(result)==true) {
		window.status = "Pas de disponibilits htelires obtenues";
		return;
	}

	var availabilities = new Array();
	var nodes = result.raw.parentNode.selectNodes("//Item/@href");
	for (i = 0; i < nodes.length; i++) {
		var availability = result.raw.parentNode.selectSingleNode("//*[@id='"+nodes[i].nodeValue.split("#")[1]+"']");
		availabilities[i] = availability;
	}

	var information = "<p>Pas de disponibilits trouves selon vos critres de rservation</p>";
	if (availabilities.length!=0) {
		getHotelTemplates()[4][2] = departure_day.value + " " + monthAsString(departure_month.value-1);
		getHotelTemplates()[5][2] = arrival_day.value + " " + monthAsString(arrival_month.value-1);
		var information = build_availabilities(availabilities, getHotelTemplates(), "hotel_choice");
	}
	parent.availabilities.hotels.innerHTML = information;

	switch_frame(parent.availabilities);

	window.status = "Disponibilits htelires obtenues";
}

/*
* Gre la rponse du serveur  une nouvelle demande
* de rcupration des disponibilits automobiles.
*
* @param		result le rsultat de l'appel SOAP
*/
function get_carAvailabilities_callback(result) {  
	if (soap_error(result)==true) {
		window.status = "Pas de disponibilits automobiles obtenues";
		return;
	}

	var availabilities = new Array();
	var nodes = result.raw.parentNode.selectNodes("//Item/@href");
	for (i = 0; i < nodes.length; i++) {
		var availability = result.raw.parentNode.selectSingleNode("//*[@id='"+nodes[i].nodeValue.split("#")[1]+"']");
		availabilities[i] = availability;
	}

	var information = "<p>Pas de disponibilits trouves selon vos critres de rservation</p>";
	if (availabilities.length!=0) {
		getCarTemplates()[4][2] = departure_day.value + " " + monthAsString(departure_month.value-1);
		getCarTemplates()[5][2] = arrival_day.value + " " + monthAsString(arrival_month.value-1);
		var information = build_availabilities(availabilities, getCarTemplates(), "car_choice");
	}
	parent.availabilities.cars.innerHTML = information;

	switch_frame(parent.availabilities);

	window.status = "Disponibilits automobiles obtenues";
}

/*
* Construit une table de disponibilits en fonction des
* disponibilits passes en paramtre et du modle de la
* table correspondante.
*
* @param		availabilities les disponibilits  afficher
* @param		templates le modle de la table des disponibilits
* @param		choice le nom du champ de slection de disponibilit
*/

function build_availabilities(availabilities, templates, choice) {  
	var string = "<table border=\"0\" cellspacing=\"1\" align=\"center\">\n";
	string = string +  "	<tr>\n"; 
	for (i = 0; i < templates.length; i++) {
		string = string +  "		<td width=\"" + templates[i][0] + "\"  align=\"center\" class=\"tdhead\">" + templates[i][1] + "</td>\n";
	}
	string = string +  "	</tr>\n";
	var checked = "checked";
	var styleClass = "tdeven";
	for (i = 0; i < availabilities.length; i++) {
		string = string +  "	<tr valign=\"middle\">\n"; 
		for (j = 0; j < templates.length; j++) {
			try {
				var value = eval("availabilities[i].getElementsByTagName(\""+templates[j][2]+"\")[0].firstChild.nodeValue");
			}
			catch (e) {
				var value = templates[j][2];
			}
			if (j==0) {
				string = string +  "		<td width=\"" + templates[j][0] + "\" align=\"center\" class=\"" + styleClass + "\">\n"; 
				string = string +  "			<input type=\"radio\" name=\"" + choice + "\" value=\"" + value + "\" " + checked + ">\n";
				string = string +  "		</td>\n";
			}
			else {
				string = string +  "		<td width=\"" + templates[j][0] + "\" align=\"center\" class=\"" + styleClass + "\">" + value + "</td>\n";
			}
		}
		string = string +  "	</tr>\n";
		if ((i % 2)==0) {
			styleClass = "tdodd";
		}
		else {
			styleClass = "tdeven";
		}
		checked = "";
	}
	string = string +  "</table>\n";
	return string
}

/*
* Demande au serveur d'effectuer une annulation de
* recherche de disponibilits. 
*/
function cancel_onclick() {
	try {
		parent.reservation.service.ReservationService.callService(
			cancel_callback,"cancel",parent.reservation.getReservationId());
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
	window.status = "Recherche de disponibilits annule";
}

/*
* Gre la rponse du serveur  une demande
* d'annulation de recherche de disponibilits.
*
* @param		result le rsultat de l'appel SOAP
*/
function cancel_callback(result) {  
	if (soap_error(result) == true) {
		return;
	}
	setReservationId(null);

	var information = "<p>Slectionnez vos critres de rservation SVP</p>";
	departureFlights.innerHTML = information;
	arrivalFlights.innerHTML = information;
	hotels.innerHTML = information;
	cars.innerHTML = information;

	switch_frame(parent.reservation);

	window.status = "Demande de disponibilits annule";
}

/*
* Demande au serveur d'effectuer une rservation des
* disponibilits slectionnes. 
*/
function book_onclick() {
	try {
		parent.reservation.service.ReservationService.callService(
			book_callback, "book", parent.reservation.getReservationId(),
			get_selectedChoice_id("departure_choice"), get_selectedChoice_id("arrival_choice"),
			get_selectedChoice_id("hotel_choice"), get_selectedChoice_id("car_choice"));
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
	window.status = "Rservation en cours...";
}

/*
* Gre la rponse du serveur  une demande
* de rservation de disponibilits.
*
* @param		result le rsultat de l'appel SOAP
*/
function book_callback(result) {  
	if (soap_error(result) == true) {
		return;
	}

	switch_frame(parent.reservation);

	window.status = "Rservation effectue";

	var more = window.confirm("Votre rservation a t enregistre sous le n"+parent.reservation.getReservationId()
		+"\n( rappeler dans toute correspondance).\n\nVoulez-vous effectuer une autre rservation ?");
	setReservationId(null);
	if (more) { 
		return;
	}
	top.close();
}

/*
* Gre les erreurs SOAP.
*
* @param		result le rsultat renvoy par la dernire
*				invocation SOAP
* @return		boolean renvoie "true" si une erreur SOAP
*				a t retourne  la suite de la dernire
*				invocation
*/
function soap_error(result) {  
    if (result.error) {  
		var faultCode = result.errorDetail.code;
		var faultString = result.errorDetail.string;    
		var errorString = faultCode + " - " + faultString;
		alert("A service error occurred : " + errorString);
		return true;
	}
	return false;
}

/*
* Commute les autorisations d'accs entre
* les deux cadres.
*/
function switch_frame(frame) {
	if (frame==parent.availabilities) {
		frame.cancel.disabled = false;
		frame.book.disabled = false;
		search.disabled = true;
	
		from.disabled = true;
		to.disabled = true;
		departure_day.disabled = true;
		departure_month.disabled = true;
		departure_year.disabled = true;
		arrival_day.disabled = true;
		arrival_month.disabled = true;
		arrival_year.disabled = true;
		roundtrip.disabled = true;
		passengers.disabled = true;
	
		hotel.disabled = true;
		car.disabled = true;
	}
	else {
		parent.availabilities.cancel.disabled = true;
		parent.availabilities.book.disabled = true;
		frame.search.disabled = false;

		frame.from.disabled = false;
		frame.to.disabled = false;
		frame.departure_day.disabled = false;
		frame.departure_month.disabled = false;
		frame.departure_year.disabled = false;
		frame.arrival_day.disabled = false;
		frame.arrival_month.disabled = false;
		frame.arrival_year.disabled = false;
		frame.roundtrip.disabled = false;
		frame.passengers.disabled = false;
	
		frame.hotel.disabled = false;
		frame.car.disabled = false;
	}
}

/*
* Gre la validation globale des modifications
* des caractristiques de rservation.
*/
function is_reservation_ok() {
	if (from.value=="") {
		search.disabled = true;
		return;
	}
	if (to.value=="") {
		search.disabled = true;
		return;
	}
	if (isNaN(parseInt(passengers.value, 10))) {
		search.disabled = true;
		return;
	}
	if (from.value==to.value) {
		search.disabled = true;
		return;
	}
	if (arrival_year.value<departure_year.value) {
		search.disabled = true;
		return;
	}
	if (arrival_year.value==departure_year.value &&
		parseInt(arrival_month.value, 10)<parseInt(departure_month.value, 10)) {
		search.disabled = true;
		return;
	}
	if (arrival_year.value==departure_year.value &&
		parseInt(arrival_month.value, 10)==parseInt(departure_month.value, 10) &&
		arrival_day.value<departure_day.value) {
		search.disabled = true;
		return;
	}
	search.disabled = false;
}

/*
* Gre la saisie de la localit de dpart.
*/
function from_onchange() {
	is_reservation_ok();
}

/*
* Gre la saisie de la localit d'arrive.
*/
function to_onchange() {
	is_reservation_ok();
}

/*
* Gre la saisie du jour de dpart.
*/
function departure_day_onchange() {
	departure_day.selectedIndex=departure_day.value-1;
	is_reservation_ok();
}

/*
* Gre la saisie du mois de dpart.
*/
function departure_month_onchange() {
	departure_month.selectedIndex=departure_month.value-1;
	update_departure_day_listbox();
	is_reservation_ok();
}

/*
* Gre la saisie de l'anne de dpart.
*/
function departure_year_onchange() {
	departure_year.selectedIndex=departure_year.value-new Date().getYear();
	update_departure_day_listbox();
	is_reservation_ok();
}

/*
* Gre la saisie du jour d'arrive.
*/
function arrival_day_onchange() {
	arrival_day.selectedIndex=arrival_day.value-1;
	is_reservation_ok();
}

/*
* Gre la saisie du mois d'arrive.
*/
function arrival_month_onchange() {
	arrival_month.selectedIndex=arrival_month.value-1;
	update_arrival_day_listbox();
	is_reservation_ok();
}

/*
* Gre la saisie de l'anne d'arrive.
*/
function arrival_year_onchange() {
	arrival_year.selectedIndex=arrival_year.value-new Date().getYear();
	update_arrival_day_listbox();
	is_reservation_ok();
}

/*
* Gre la saisie du type de voyage
* (Aller simple ou Aller retour).
*/
function roundtrip_onchange() {
	is_reservation_ok();
}

/*
* Gre la saisie du nombre de voyageurs.
*/
function passengers_onchange() {
	is_reservation_ok();
}

/*
* Actualise la list-box du jour de la date de dpart
* en fonction du mois et de l'anne slectionns.
*/
function update_departure_day_listbox() {
	var nbdays = maximumDays(departure_year.value, departure_month.value-1);
	if (nbdays==departure_day.options.length) {
		return;
	}
	if (nbdays - departure_day.options.length < 0) {
		while (nbdays - departure_day.options.length != 0) {
			var i = departure_day.options.length - 1;
			departure_day.options.remove(i);
		}
	}
	else {
		while (nbdays - departure_day.options.length != 0) {
 			var option = document.createElement("option");
			option.text=new Number(departure_day.options.length+1).toString();
			option.value=departure_day.options.length+1;
			departure_day.add(option, departure_day.options.length+1);
		}
	}
}

/*
* Actualise la list-box du jour de la date d'arrive
* en fonction du mois et de l'anne slectionns.
*/
function update_arrival_day_listbox() {
	var nbdays = maximumDays(arrival_year.value, arrival_month.value-1);
	if (nbdays==arrival_day.options.length) {
		return;
	}
	if (nbdays - arrival_day.options.length < 0) {
		while (nbdays - arrival_day.options.length != 0) {
			var i = arrival_day.options.length - 1;
			arrival_day.options.remove(i);
		}
	}
	else {
		while (nbdays - arrival_day.options.length != 0) {
 			var option = document.createElement("option");
			option.text=new Number(arrival_day.options.length+1).toString();
			option.value=arrival_day.options.length+1;
			arrival_day.add(option, arrival_day.options.length+1);
		}
	}
}

/*
* Renvoie l'identifiant de la disponibilit
* choisie.
*/
function get_selectedChoice_id(radioIds) {
	var choices = document.all.item(radioIds);
	if (choices==null || choices.length==0) {
		return 0;
	}
	for (i=0; i<choices.length; i++) {
		var choice = document.all.item(radioIds,i)
		if (choice.checked) {
			return choice.value;
		}
	}
}

/*
* Gre l'vnement de dchargement de
* la fentre de rservation.
*/
function reservation_window_onunload() {
	try {
		service.ReservationService.callService(cancel_callback,"cancel",getReservationId());
	}
	catch (e) {
		alert("erreur("+e.number+") : "+e.description);
	}
	window.status = "";
}

/*
* Gre l'vnement d'imminence de dchargement 
* de la fentre de rservation. Protge l'utilisateur
* contre une sortie non dsire de l'application.
*/
function reservation_window_onbeforeunload() {
	window.event.returnValue = "Abandonner la rservation en cours ?";
}

/*
* Renvoie le nombre de jours maximum d'un
* mois donn pour une anne donne.
*/
var days;
function maximumDays(year, month) {
	if (days==null) {
		days = new Array(31,28,31,30,31,30,31,31,30,31,30,31);
	}
	if (month!=1) {
		return days[month];
	}
	if (((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0)) {
		return 29;
	}
	return 28
}

/*
* Renvoie le mois pass en paramtre sous
* forme d'une chane de caractres.
*/
var months;
function monthAsString(month) {
	if (months==null) {
		months = new Array("Janvier","Fvrier","Mars","Avril","Mai","Juin",
			"Juillet","Aot","Septembre","Octobre","Novembre","Dcembre");
	}
	return months[month];
}